<?php

namespace app\admin\controller;

use think\captcha\facade\Captcha;
use think\facade\Session;
use think\facade\View;

class Login
{
    //登录页面
    public function index()
    {
        if (Session::has('adminInfo')) {
            return redirect('/Admin/Index/index');
        }
        $sys_name = config('system.system_name');
        View::assign(['system_name' => $sys_name]);
        return View::fetch();
    }

    // 验证码
    public function captcha()
    {
        return Captcha::create();
    }

    //登录验证
    public function checkLogin()
    {
        $admin_model = new \app\common\model\Admin();
        return $admin_model->checkLogin();
    }

    //退出
    public function logout()
    {
        Session::clear();
        return redirect('index');
    }

}
